using System;

using DarkStrideToolbox;


namespace MetalMarines
{
	public struct structAAFire
	{
		public long m_nSourceX;
		public long m_nSourceY;
		public bool m_bHits;
		public long m_nPercToHitAt;
		public long m_nXDeviation;
		public long m_nYDeviation;
		public bool m_bLaunchSoundFired;
	}


	public class MissleAttack
	{
		#region Properties
		private string m_sSourceIslandGlobalID = "";
		private long m_nSourceX = 0;
		private long m_nSourceY = 0;
		private string m_sTargetIslandGlobalID = "";
		private long m_nTargetX = 0;
		private long m_nTargetY = 0;
		private DSSortedList m_oAAFire = new DSSortedList();
		//Only AA guns that have two barrels can fire at a "Second Shot"
		private long m_nShotNumber = 1;
		private long m_nTotalNumberOfShots = 1;
		private double m_nOffensive = 0;
		private bool m_bIsAntiMatter = false;
		private long m_nExplosionRadius = 0;

		private bool m_bDetonated = false;
		private double m_nPercentAlongPath = 0;
		private string m_sGlobalID = "";

		private long m_nSoundIndex = -1;
		private long m_nColor = 0;

		private static string m_cATTACK_SEP = "[AS]";
		private static string m_cAAFIRE_SEP = "[AAFS]";
		private static double m_cSECONDSTOATTACK = 4.0;
		#endregion
        

		public MissleAttack()
		{
			m_sGlobalID = DSMisc.GetGUID();
		}


		public bool GetsHit( ref long nPercentHitAt )
		{
			bool bGetsHit = false;
			structAAFire oLoopAAFire;


			for( int nLoopAAFireIndex=0 ; nLoopAAFireIndex<m_oAAFire.Count ; nLoopAAFireIndex++ )
			{
				oLoopAAFire = (structAAFire)m_oAAFire.GetByIndex( nLoopAAFireIndex );

				if( oLoopAAFire.m_bHits == true )
				{
					bGetsHit = true;
					nPercentHitAt = oLoopAAFire.m_nPercToHitAt;
				}
			}


			return( bGetsHit );
		}

		public void Advance( double nElapsedTime )
		{
			//We want it to take roughly X seconds
			m_nPercentAlongPath += ( 100.0 / m_cSECONDSTOATTACK ) * nElapsedTime;
		}

		public void AddAAFire( long nSourceX,long nSourceY,bool bHits,long nPercToHitAt,long nXDeviation,long nYDeviation )
		{
			structAAFire oAAFire;

			oAAFire.m_nSourceX = nSourceX;
			oAAFire.m_nSourceY = nSourceY;
			oAAFire.m_bHits = bHits;
			oAAFire.m_nPercToHitAt = nPercToHitAt;
			oAAFire.m_nXDeviation = nXDeviation;
			oAAFire.m_nYDeviation = nYDeviation;
			oAAFire.m_bLaunchSoundFired = false;

			m_oAAFire.Add( DSMisc.GetGUID(),oAAFire );
		}


		public string Serialize()
		{
			string sRetVal = "";
			string sAAFire = "";
			structAAFire oLoopAAFire;


			//Assemble our AAFire
			for( int nLoopAAFireIndex=0 ; nLoopAAFireIndex<m_oAAFire.Count ; nLoopAAFireIndex++ )
			{
				oLoopAAFire = (structAAFire)m_oAAFire.GetByIndex( nLoopAAFireIndex );

				sAAFire +=	oLoopAAFire.m_nSourceX.ToString() +  m_cAAFIRE_SEP + 
					oLoopAAFire.m_nSourceY.ToString() +  m_cAAFIRE_SEP + 
					oLoopAAFire.m_bHits.ToString() +  m_cAAFIRE_SEP + 
					oLoopAAFire.m_nPercToHitAt.ToString() +  m_cAAFIRE_SEP + 
					oLoopAAFire.m_nXDeviation.ToString() +  m_cAAFIRE_SEP + 
					oLoopAAFire.m_nYDeviation.ToString() +  m_cAAFIRE_SEP;
			}

			//Now write all the square information
			sRetVal = m_sSourceIslandGlobalID + m_cATTACK_SEP +
				m_nSourceX.ToString() + m_cATTACK_SEP + 
				m_nSourceY.ToString() + m_cATTACK_SEP +
				m_sTargetIslandGlobalID + m_cATTACK_SEP +
				m_nTargetX.ToString() + m_cATTACK_SEP + 
				m_nTargetY.ToString() + m_cATTACK_SEP + 
				m_sGlobalID + m_cATTACK_SEP + 
				m_nShotNumber.ToString() + m_cATTACK_SEP +
				m_nTotalNumberOfShots.ToString() + m_cATTACK_SEP + 
				m_nOffensive.ToString() + m_cATTACK_SEP + 
				m_bIsAntiMatter.ToString() + m_cATTACK_SEP + 
				m_nExplosionRadius.ToString() + m_cATTACK_SEP + 
				m_nColor.ToString() + m_cATTACK_SEP +
				sAAFire + m_cATTACK_SEP;


			return( sRetVal );
		}
		public void DeSerialize( string sRecord )
		{
			structAAFire oAAFire;
			string[] saAttackParamaters = null;
			string[] saAAFires = null;

			saAttackParamaters = DSMisc.Split( sRecord,m_cATTACK_SEP );

			//Now update this island
			m_sSourceIslandGlobalID	= saAttackParamaters[ 0 ];
			m_nSourceX				= Convert.ToInt64( saAttackParamaters[ 1 ] );
			m_nSourceY				= Convert.ToInt64( saAttackParamaters[ 2 ] );
			m_sTargetIslandGlobalID	= saAttackParamaters[ 3 ];
			m_nTargetX				= Convert.ToInt64( saAttackParamaters[ 4 ] );
			m_nTargetY				= Convert.ToInt64( saAttackParamaters[ 5 ] );
			m_sGlobalID				= saAttackParamaters[ 6 ];
			m_nShotNumber			= Convert.ToInt64( saAttackParamaters[ 7 ] );
			m_nTotalNumberOfShots	= Convert.ToInt64( saAttackParamaters[ 8 ] );
			m_nOffensive			= Convert.ToInt64( saAttackParamaters[ 9 ] );
			m_bIsAntiMatter			= Convert.ToBoolean( saAttackParamaters[ 10 ] );
			m_nExplosionRadius		= Convert.ToInt64( saAttackParamaters[ 11 ] );
			m_nColor				= Convert.ToInt64( saAttackParamaters[ 12 ] );

				
			saAAFires = DSMisc.Split( saAttackParamaters[ 13 ],m_cAAFIRE_SEP );

			//Add our AA fire
			for( int i=0 ; i<saAAFires.Length-1 ; i+=6 )
			{
				oAAFire.m_nSourceX		= Convert.ToInt64( saAAFires[ i ] );
				oAAFire.m_nSourceY		= Convert.ToInt64( saAAFires[ i+1 ] );
				oAAFire.m_bHits			= Convert.ToBoolean( saAAFires[ i+2 ] );
				oAAFire.m_nPercToHitAt	= Convert.ToInt64( saAAFires[ i+3 ] );
				oAAFire.m_nXDeviation	= Convert.ToInt64( saAAFires[ i+4 ] );
				oAAFire.m_nYDeviation	= Convert.ToInt64( saAAFires[ i+5 ] );
				oAAFire.m_bLaunchSoundFired = false;

				m_oAAFire.Add( DSMisc.GetGUID(),oAAFire );
			}
		}



		#region Properties
		public string SourceIslandGlobalID
		{
			get
			{
				return( m_sSourceIslandGlobalID );
			}
			set
			{
				m_sSourceIslandGlobalID = value;
			}
		}
		public long SourceX
		{
			get
			{
				return( m_nSourceX );
			}
			set
			{
				m_nSourceX = value;
			}
		}
		public long SourceY
		{
			get
			{
				return( m_nSourceY );
			}
			set
			{
				m_nSourceY = value;
			}
		}
		public string TargetIslandGlobalID
		{
			get
			{
				return( m_sTargetIslandGlobalID );
			}
			set
			{
				m_sTargetIslandGlobalID = value;
			}
		}
		public long TargetX
		{
			get
			{
				return( m_nTargetX );
			}
			set
			{
				m_nTargetX = value;
			}
		}
		public long TargetY
		{
			get
			{
				return( m_nTargetY );
			}
			set
			{
				m_nTargetY = value;
			}
		}
		public double PercentAlongPath
		{
			get
			{
				return( m_nPercentAlongPath );
			}
			set
			{
				m_nPercentAlongPath = value;
			}
		}			
		public string GlobalID
		{
			get
			{
				return( m_sGlobalID );
			}
			set
			{
				m_sGlobalID = value;
			}
		}
		public long ShotNumber
		{
			get
			{
				return( m_nShotNumber );
			}
			set
			{
				m_nShotNumber = value;
			}
		}
		public long TotalNumberOfShots
		{
			get
			{
				return( m_nTotalNumberOfShots );
			}
			set
			{
				m_nTotalNumberOfShots = value;
			}
		}
		public DSSortedList AAFire
		{
			get
			{
				return( m_oAAFire );
			}
			set
			{
				m_oAAFire = value;
			}
		}
		public double Offensive
		{
			get
			{
				return( m_nOffensive );
			}
			set
			{
				m_nOffensive = value;
			}
		}
		public bool IsAntiMatter
		{
			get
			{
				return( m_bIsAntiMatter );
			}
			set
			{
				m_bIsAntiMatter = value;
			}
		}
		public bool Detonated
		{
			get
			{
				return( m_bDetonated );
			}
			set
			{
				m_bDetonated = value;
			}
		}
		public long ExplosionRadius
		{
			get
			{
				return( m_nExplosionRadius );
			}
			set
			{
				m_nExplosionRadius = value;
			}
		}		

		public long SoundIndex
		{
			get
			{
				return( m_nSoundIndex );
			}
			set
			{
				m_nSoundIndex = value;
			}
		}
		public long Color
		{
			get
			{
				return( m_nColor );
			}
			set
			{
				m_nColor = value;
			}
		}
		#endregion
	}
}
